<?php
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    * 
    * classe per stampare i contenuti nelle pagine dinamich del sito
    */
    class StampaContenuti {
        
        /*
            questo metodo viene usata nelle pagine index.php categoria.php e sequenza.php per stampare
            gli articoli. Nella home viene usata per gli articoli dopo il primo, invece
            nella pagina cerca viene usata per tutti gli articoli
        */
        static function stampaArticoliSuccessiviAlPrimo($gestoreTraduzioni,$contenuto,$aspetto,$formatoImmagineInEvidenza,$linkContenuto,$impostazioniAspetto,$arrayCategorie,$numeroCommenti) {
            $data = date("d/m/Y",strtotime($contenuto["dataPubblicazione"]));
            $testo = explode("<!-- leggi tutto -->",$contenuto["testo"]);
            $prefissoImmagine = "";
            if($impostazioniAspetto["ottimizzazioneUrl"]=="si") {
                $prefissoImmagine = $impostazioniAspetto["urlSito"];
            }

            if($aspetto=="classico") {
                StampaContenuti::visualizzazioneClassica($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto,$testo[0],$data,$arrayCategorie,$numeroCommenti,"col-12");
            }
            else if($aspetto=="classico, senza troncamento") {
                StampaContenuti::visualizzazioneClassica($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto,$testo[0],$data,$arrayCategorie,$numeroCommenti,"col-12",false);
            }
            else if($aspetto=="Compatto") { //visualizzazione compatta, con foto a sinistra e testo a destra
                StampaContenuti::visualizzazioneCompatta($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto,$testo[0],$data,$arrayCategorie,$numeroCommenti,"col-12");
            }
            else if($aspetto=="Compatto, 2 per riga") { //visualizzazione compatta, con foto a sinistra e testo a destra
                StampaContenuti::articoliAffiancati($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto, $arrayCategorie, "col-md-6","si");
            }
            else if($aspetto=="titolo sovrapposto") {
                StampaContenuti::visualizzazioneTitoloSovrapposto($contenuto,$linkContenuto,$arrayCategorie);
            }
            else { //solo titolo
                StampaContenuti::visualizzazioneSoloTitolo($linkContenuto, $contenuto["titolo"]);
            }
        }
        
        /*
         * questo metodo è deputato solo alla stampa dei risultati di ricerca, che
         * possono avere un aspetto differente dagli altri risultati
         */
        static function stampaRisultatiRicerca($gestoreTraduzioni,$contenuto,$formatoImmagineInEvidenza,$linkContenuto,$arrayCategorie,$numeroCommenti,$classe="col-12") {
            $arrayTesto        = explode("<!-- leggi tutto -->",$contenuto["testo"]);
            $testoAnteprima    = $arrayTesto[0];
            $dataPubblicazione = date("d/m/Y",strtotime($contenuto["dataPubblicazione"]));
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            
            if($contenuto["foto"]!="") {
                echo"<div class=\"$classe\">";
                    echo"<div class=\"card px-0 mb-5 box-shadow-lite doppia-colonna rounded-0\">
                            <div class=\"row\">
                                <div class=\"col-xl-6 pr-xl-0\">
                                <div class=\"img-container zoom\">
                                    <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>";
                                        if($formatoImmagineInEvidenza!="") {
                                            echo"<div class=\"$formatoImmagineInEvidenza\">
                                                <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                                            </div>";
                                        }
                                        else {
                                            echo"<img class=\"img-fluid\" src=\"{$contenuto["foto"]}\">";
                                        }

                                    echo"<div class=\"overlay\"></div>";
                                    echo StampaContenuti::generaCodiceCategoria($arrayCategorie);
                            echo"</div>
                        </div>
                        <div class=\"col-xl-6 pl-xl-0 \">
                            <div class=\"px-4 py-3\">
                               <p class=\"text-muted small pb-2 mb-2 border-bottom\">
                                     <i class=\"fas fa-user mr-2\"></i><a href=\"cerca.php?tipoRicerca=autore&chiaveRicerca={$contenuto["autore"]}\">{$contenuto["autore"]}</a> <i class=\"fas fa-calendar-alt ml-4 mr-1\"></i> $dataPubblicazione
                                     <span class=\"float-right text-primary\"><i class=\"fas fa-comments\"> </i> $numeroCommenti</span>
                               </p>
                               <h2><a href=\"$linkContenuto\">{$contenuto["titolo"]}</a></h2>
                               <div class=\"intro-text\">
                               $testoAnteprima
                               </div>
                            </div>
                        </div>
                        <a href=\"$linkContenuto\" class=\"btn btn-primary leggi-tutto btn-sm sharp text-white outline\">$stringaLeggiTutto</a>
                    </div>
                    </div>
                </div>";
            }
            else {
                StampaContenuti::visualizzazioneSenzaImmagine($gestoreTraduzioni,$contenuto,$linkContenuto,$testoAnteprima);
            }
        }
        
        /*
         * il campo @classe se non viene specificato è col-lg-4. Attualmente viene modificato 
         * solo per articoli dal blog
         * il campo @mostraTesto se non viene specificato = si. Attualmente viene modificato 
         * solo per articoli dal blog
         */
        static function articoliAffiancati($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto,$arrayCategorie, $classe="col-lg-4", $mostraTesto="si") {
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            $testo = explode("<!-- leggi tutto -->",$contenuto["testo"]);
            $dataPubblicazione = date("d/m/Y",strtotime($contenuto["dataPubblicazione"]));
            if($contenuto["foto"]!="") {
                $fotoDaInserire = ($contenuto["miniaturaFoto"]!="") ?  $contenuto["miniaturaFoto"] : $contenuto["foto"];
                echo"<div class=\"$classe d-flex\">";
                echo"<div class=\"card px-0 mb-5 box-shadow-lite w-100\">";
                echo"<div class=\"img-container zoom\">
                        <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>";
                        if($formatoImmagineInEvidenza!="") {
                           echo"<div class=\"$formatoImmagineInEvidenza\">    
                                <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                            </div>";
                        }
                        else {
                            echo"<img class=\"img-fluid\" src=\"{$contenuto["foto"]}\" >";
                        }
                        echo"<div class=\"overlay\"></div>";
                        echo StampaContenuti::generaCodiceCategoria($arrayCategorie);
                echo"</div>";
                $classeAggiuntivaDivContenitore = ($mostraTesto=="si") ? "pb-5" : "";
                echo"<div class=\"p-3 $classeAggiuntivaDivContenitore\">";
                echo"<p class=\"text-muted small pb-2 border-bottom\">
                        <i class=\"fas fa-user mr-2\"></i><a href=\"cerca.php?tipoRicerca=autore&chiaveRicerca={$contenuto["autore"]}\">{$contenuto["autore"]}</a> <i class=\"fas fa-calendar-alt ml-2 mr-1\"></i> $dataPubblicazione
                    </p>";
                echo"<a href=\"$linkContenuto\"><h5 class=\"titolo mt-2\"> {$contenuto["titolo"]}</h5></a>";
                if($mostraTesto=="si") {
                    echo "<div class=\"intro-text\">
                        {$testo[0]}
                    </div>";
                    echo"<a class=\"btn btn-primary btn-sm leggi-tutto sharp text-white outline float-right\" href=\"$linkContenuto\">$stringaLeggiTutto</a>";
                }
                echo"</div>"
                . "</div>"
                . "</div>";
            }
            else {
                StampaContenuti::visualizzazioneSenzaImmagine($contenuto,$linkContenuto,$classe);
            }
        }
        
        /*
         * Questo metodo è simile ad articoli affiancati, ma consente la stampa di un qualsiasi tipo
         * di contenuto: sia esso un articolo, un'immagine o una galleria.
         * 
         * Nota: questo componente richiede che sia presente un'immagine in evidenza
         * 
         * il campo @classe se non viene specificato è col-lg-4. Attualmente viene modificato 
         * solo per il componente Colonne in evidenza
         * il campo @mostraTesto se non viene specificato = si. Attualmente viene modificato 
         * solo per il componente Colonne in evidenza
         */
        static function contenutiAffiancati($gestoreTraduzioni,$contenuto, $linkContenuto, $classe="col-lg-4", $mostraTesto="si",$testoAnteprima="") {
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            $testo = explode("<!-- leggi tutto -->",$contenuto["testo"]);            
            echo"<div class=\"$classe d-flex\">";
                echo"<div class=\"card px-0 mb-5 box-shadow-lite w-100\">";
                    echo"<div class=\"img-container zoom\">
                            <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>
                            <div class=\"aspect-ratio-16-9\">
                                <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                            </div>
                            <div class=\"overlay\"></div>";
                    echo"</div>";
                    echo"<div class=\"p-3\">";

                    echo"<a href=\"$linkContenuto\"><h5 class=\"titolo mt-2\"> {$contenuto["titolo"]}</h5></a>";
                    if($mostraTesto=="si") {
                        echo "<div class=\"intro-text\">";
                        echo(($testoAnteprima=="") ? $testo[0]: $testoAnteprima);
                        echo"</div>";
                    }
                    echo"<a class=\"btn btn-primary btn-sm leggi-tutto sharp text-white outline float-right\" href=\"$linkContenuto\">$stringaLeggiTutto</a>";
                    echo"</div>"
                . "</div>"
            . "</div>";
        }
        
        static function visualizzazioneTitoloSovrapposto($contenuto, $linkContenuto,$arrayCategorie) {
            if($contenuto["foto"]!="") {
                echo"<div class=\"col-12\">"
                . "<div class=\"card px-0 mb-5 box-shadow-lite\">";
                echo"<div class=\"img-container zoom\">
                        <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>
                        <div class=\"aspect-ratio-16-9\">    
                            <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                        </div>
                        <div class=\"overlay\"></div>";
                        echo StampaContenuti::generaCodiceCategoria($arrayCategorie);
                echo"</div>";
                echo"<div class=\"titolo-sovrapposto stile-2\">";
                
                echo"<a href=\"$linkContenuto\"><h2 class=\"titolo\"> {$contenuto["titolo"]}</h2></a>
                     </div>"
                . "</div>"
                ."</div>";
            }
            else {
                StampaContenuti::visualizzazioneSenzaImmagine($gestoreTraduzioni,$contenuto,$linkContenuto);
            }
        }
        
        static function visualizzazioneClassica($gestoreTraduzioni,$contenuto, $formatoImmagineInEvidenza, $linkContenuto, $testoAnteprima,$dataPubblicazione,$arrayCategorie,$numeroCommenti,$classeDivContenitore = "col-12", $effettuaTroncamento=true) {
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            $classeDivContenitoreTesto = ($effettuaTroncamento==true) ? "intro-text" : "";
            if($contenuto["foto"]!="") {
                echo"<div class=\"$classeDivContenitore\">";
                echo"<div class=\"card px-0 mb-5 box-shadow-lite\">";
                echo"<div class=\"img-container zoom\">
                        <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>";
                        if($formatoImmagineInEvidenza!="") {
                           echo"<div class=\"$formatoImmagineInEvidenza\">    
                                <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                            </div>";
                        }
                        else {
                            echo"<img class=\"img-fluid\" src=\"{$contenuto["foto"]}\" >";
                        }
                        echo"<div class=\"overlay\"></div>";
                        echo StampaContenuti::generaCodiceCategoria($arrayCategorie);
                echo"</div>";
                echo"<div class=\"p-4\">";
                echo"<p class=\"text-muted small pb-2 border-bottom\">
                        <i class=\"fas fa-user mr-2\"></i><a href=\"cerca.php?tipoRicerca=autore&chiaveRicerca={$contenuto["autore"]}\">{$contenuto["autore"]}</a> <i class=\"fas fa-calendar-alt ml-4 mr-1\"></i> $dataPubblicazione
                        <span class=\"float-right text-primary\"><i class=\"fas fa-comments\"> </i> $numeroCommenti</span>
                    </p>";
                echo"<a href=\"$linkContenuto\"><h2 class=\"titolo\"> {$contenuto["titolo"]}</h2></a>
                <div class=\"$classeDivContenitoreTesto\">";
                echo $testoAnteprima;
                echo"</div>
                    <a class=\"btn btn-primary btn-sm leggi-tutto sharp text-white outline float-right\" href=\"$linkContenuto\">$stringaLeggiTutto</a>";
                echo"</div>"
                . "</div>";
                echo"</div>";
            }
            else {
                StampaContenuti::visualizzazioneSenzaImmagine($gestoreTraduzioni,$contenuto,$linkContenuto);
            }
        }
        
        static function visualizzazioneCompatta($gestoreTraduzioni,$contenuto,$formatoImmagineInEvidenza,$linkContenuto,$testoAnteprima,$dataPubblicazione,$arrayCategorie,$numeroCommenti, $classeDivContenitore = "col-12") {
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            if($contenuto["foto"]!="") {
                $fotoDaInserire = ($contenuto["miniaturaFoto"]!="") ?  $contenuto["miniaturaFoto"] : $contenuto["foto"];
                echo"<div class=\"$classeDivContenitore\">";
                echo"<div class=\"card px-0 mb-5 box-shadow-lite doppia-colonna rounded-0\">
                        <div class=\"row\">
                            <div class=\"col-xl-6 pr-xl-0\">
                            <div class=\"img-container zoom\">
                                <div class=\"main-link\"> <a href=\"$linkContenuto\"></a></div>";
                                if($formatoImmagineInEvidenza!="") {
                                    echo"<div class=\"$formatoImmagineInEvidenza\">    
                                         <div class=\"background-image\" style=\"background-image: url('{$contenuto["foto"]}')\"></div>
                                     </div>";
                                 }
                                 else {
                                     echo"<img class=\"img-fluid\" src=\"{$contenuto["foto"]}\" >";
                                 }
                                echo"<div class=\"overlay\"></div>";
                                echo StampaContenuti::generaCodiceCategoria($arrayCategorie);
                        echo"</div>
                    </div>
                    <div class=\"col-xl-6 pl-xl-0 \">
                        <div class=\"px-4 py-3\">
                           <p class=\"text-muted small pb-2 mb-2 border-bottom\">
                                <i class=\"fas fa-user mr-2\"></i><a href=\"cerca.php?tipoRicerca=autore&chiaveRicerca={$contenuto["autore"]}\">{$contenuto["autore"]}</a> <i class=\"fas fa-calendar-alt ml-4 mr-1\"></i> $dataPubblicazione
                                <span class=\"float-right text-primary\"><i class=\"fas fa-comments\"> </i> $numeroCommenti</span>
                           </p>
                           <h2><a href=\"$linkContenuto\">{$contenuto["titolo"]}</a></h2>
                           <div class=\"intro-text\">
                           $testoAnteprima
                           </div>
                        </div>
                    </div>
                    <a href=\"$linkContenuto\" class=\"btn btn-primary btn-sm leggi-tutto sharp text-white outline\">$stringaLeggiTutto</a>
                </div></div>";
                echo"</div>";
            }
            else {
                StampaContenuti::visualizzazioneSenzaImmagine($gestoreTraduzioni,$contenuto,$linkContenuto);
            }
        }

        /*
         * questo metodo viene usato dai metodi visualizzazioneCompatta e visualizzazioneClassica
         * quando l'articolo in input non ha l'immagine in evidenza
         */
        static function visualizzazioneSenzaImmagine($gestoreTraduzioni,$contenuto,$linkContenuto, $classe="col-12",$mostraTesto="si") {
            $stringaLeggiTutto = StampaContenuti::traduciStringaLeggiTutto($gestoreTraduzioni, $contenuto);
            $dataPubblicazione = date("d/m/Y",strtotime($contenuto["dataPubblicazione"]));
            $classeAggiuntivaDivContenitore = ($mostraTesto=="si") ? "pb-5" : "";
            $testo = explode("<!-- leggi tutto -->",$contenuto["testo"]);
            echo"<div class=\"$classe d-flex w-100\">";
            echo"<div class=\"card px-0 mb-5 box-shadow-lite w-100\">";
            echo"<div class=\"p-3 $classeAggiuntivaDivContenitore\">";
            echo"<p class=\"text-muted small pb-2 border-bottom\">
                    <i class=\"fas fa-user mr-2\"></i><a href=\"cerca.php?tipoRicerca=autore&chiaveRicerca={$contenuto["autore"]}\">{$contenuto["autore"]}</a> <i class=\"fas fa-calendar-alt ml-2 mr-1\"></i> $dataPubblicazione
                </p>";
            echo"<a href=\"$linkContenuto\"><h4 class=\"titolo mt-2\"> {$contenuto["titolo"]}</h4></a>";
            if($mostraTesto=="si") {
                echo "<div class=\"intro-text\">
                    {$testo[0]}
                </div>";
                echo"<a class=\"btn btn-primary btn-sm btn-sm leggi-tutto sharp text-white outline float-right\" href=\"$linkContenuto\">$stringaLeggiTutto</a>";
            }
            echo"</div>"
            . "</div>"
            . "</div>";
        }
        
        static function traduciStringaLeggiTutto($gestoreTraduzioni,$contenuto) {
            return $gestoreTraduzioni->traduci("Leggi tutto",$contenuto["linguaContenuto"]);
        }
        
        static function visualizzazioneSoloTitolo($linkContenuto,$titolo,$classe="col-12") {
            echo"<div class=\"$classe\">
                    <div class=\"articolo\">
                        <h2 class=\"title\"><a href=\"$linkContenuto\">{$titolo}</a></h2>
                    </div>
                </div>";
        }
               
        static function generaCodiceCategoria($arrayCategorie) {
            $stringaCodiciCategorie = "<div class=\"extra-info\">";
            foreach($arrayCategorie as $nome=>$link) {                
                $stringaCodiciCategorie .= "<a href=\"$link\" class=\"badge badge-primary rounded-0 py-2 px-3\">$nome</a>";
            }
            return $stringaCodiciCategorie."</div>";
        }
        
       /*
	*   Stampa il prodotto con img-background. 
	*   Le miniature occupano uno spazio proporzionale pari al 25% all'altezza della viewport su desktop e del 45% su mobile. 
	*   L'altezza minima viene impostata via CSS (220px).
	*/
        static function stampaProdottoImgBackground($gestoreTraduzioni,$impostazioniEcommerce,$prodotto,$linkProdotto,$categoriaProdotto,$linkCategoria,$classeProdotto,$datiGruppo,$mostraprezzo=true,$mostraAggiungiAlCarrello=true) {
	    $paggingCard = ($mostraAggiungiAlCarrello==true) ? "pb-5" : "";
            if($prodotto!=null) {
                    $classiAggiuntive = ($prodotto["prezzoOfferta"]>0) ? "popular" : "";
                    echo"<div class=\"$classeProdotto\">
                            <div class=\"card px-0 $paggingCard box-shadow-lite border w-100 mb-4 $classiAggiuntive \">
                                    <div class=\"img-container zoom\">
                                            <div class=\"main-link\"> <a href=\"$linkProdotto\"></a></div>
                                         <div class=\"aspect-ratio-4-3\">
                                             <div class=\"background-image\" style=\"background-image: url('".StampaContenuti::percorsoImmagine($prodotto)."')\"></div>
                                         </div>
                                            <div class=\"overlay\"></div>";

                                            echo"<div class=\"extra-info\">
                                                    <a href=\"$linkCategoria\" class=\"badge badge-primary rounded-0 py-2 px-3 m-2\">{$categoriaProdotto["nome"]}</a>
                                            </div>";
                                            if($prodotto["prezzoOfferta"]>0) {
                                                    echo"<span class=\"in-offerta\"></span>";
                                            }
                                    echo"</div>
                                    <div class=\"p-3\">
                                            <h5><a href=\"$linkProdotto\">{$prodotto["nome"]}</a></h5>
                                            <div class=\"intro-text\"></div>"; // TODO qui va il testo descrittivo
                                            if($mostraprezzo && $prodotto["usaVariazioni"]!="si") {                                            
                                                StampaContenuti::stampaPrezzoProdotto($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$datiGruppo);
                                            }
                                    echo"</div>";
                            if($mostraAggiungiAlCarrello==true) {
                                StampaContenuti::stampaPulsanteCarrello($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$linkProdotto,$datiGruppo);
                            }
                       echo"</div>";
                    echo"</div>";
            }
        }
        
	/*
	*   Stampa il prodotto senza img-background. In questo caso è necessario che le immagini abbiano la medesima altezza
	*/
	static function stampaProdottoSenzaImgBackground($gestoreTraduzioni,$impostazioniEcommerce,$prodotto,$linkProdotto,$categoriaProdotto,$linkCategoria,$classeProdotto,$datiGruppo,$mostraprezzo=true,$mostraAggiungiAlCarrello=true) {
            $paggingCard = ($mostraAggiungiAlCarrello==true) ? "pb-5" : "";
            if($prodotto!=null) {
                $classiAggiuntive = ($prodotto["prezzoOfferta"]>0) ? "popular" : "";
                echo"<div class=\"$classeProdotto\">
                        <div class=\"card px-0 $paggingCard box-shadow-lite border w-100 mb-4 $classiAggiuntive \">
                                <div class=\"img-container zoom\">
                                        <div class=\"main-link\"> <a href=\"$linkProdotto\"></a></div>
                                        <div class=\"overlay\"></div>";
                                        echo"<img src=\"".StampaContenuti::percorsoImmagine($prodotto)."\" class=\"img-fluid w-100\">
                                        <div class=\"extra-info\">
                                                <a href=\"$linkCategoria\" class=\"badge badge-primary rounded-0 py-2 px-3 m-2\">{$categoriaProdotto["nome"]}</a>
                                        </div>";
                                        if($prodotto["prezzoOfferta"]>0) {
                                            echo"<span class=\"in-offerta\"></span>";
                                        }
                                echo"</div>
                                <div class=\"p-3\">
                                    <h5><a href=\"$linkProdotto\">{$prodotto["nome"]}</a></h5>
                                    <div class=\"intro-text\"></div>"; // TODO qui va il testo descrittivo
                                    if($mostraprezzo && $prodotto["usaVariazioni"]!="si") {                             
                                        StampaContenuti::stampaPrezzoProdotto($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$datiGruppo);
                                    }
                                echo"</div>";
                        if($mostraAggiungiAlCarrello==true) {
                            StampaContenuti::stampaPulsanteCarrello($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$linkProdotto,$datiGruppo);
                        }
                   echo"</div>";
                echo"</div>";
            }
        }

       /*
	*   Stampa il prodotto con img-background e descrizione a lato
	*   Le miniature occupano uno spazio proporzionale pari al 25% all'altezza della viewport su desktop e del 45% su mobile. 
	*   L'altezza minima viene impostata via CSS (220px).
	*/
        static function stampaProdottoConDescrizioneBreve($gestoreTraduzioni,$impostazioniEcommerce,$prodotto,$linkProdotto,$categoriaProdotto,$linkCategoria,$classeProdotto,$datiGruppo,$mostraAggiungiAlCarrello=true) {
            if($prodotto!=null) {
                    $classiAggiuntive = ($prodotto["prezzoOfferta"]>0) ? "popular" : "";
                    echo"<div class=\"$classeProdotto\">
                            <div class=\"card px-0 mb-4 box-shadow-lite doppia-colonna rounded-0 $classiAggiuntive\">
                                <div class=\"row\">
                                    <div class=\"col-xl-6 pr-xl-0\">
                                        <div class=\"img-container zoom\">
                                            <div class=\"main-link\">
                                                <a href=\"prodotto.php?id={$prodotto["id"]}&alias={$prodotto["alias"]}\"></a>
                                            </div>
                                            <div class=\"aspect-ratio-16-9\">
                                                <div class=\"background-image\" style=\"background-image: url('".StampaContenuti::percorsoImmagine($prodotto)."')\"></div>
                                            </div>
                                            <div class=\"overlay\"></div>
                                            <div class=\"extra-info\">
                                                <a href=\"$linkCategoria\" class=\"badge badge-primary rounded-0 py-2 px-3 m-2\">{$categoriaProdotto["nome"]}</a>
                                            </div>";
                                            if($prodotto["prezzoOfferta"]>0) {
                                                echo"<span class=\"in-offerta\"></span>";
                                            }
                                    echo"</div>
                                    </div>
                                    <div class=\"col-xl-6 p-5 p-xl-3\">
                                        <h5 class=\"mb-2\">{$prodotto["nome"]} 2</h5>
                                        <p class=\"text-truncate-3\">". strip_tags($prodotto["descrizione"])."</p> 
                                        <div class=\"row mt-2\">
                                            <div class=\"col\">";
                                            StampaContenuti::stampaPrezzoProdotto($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$datiGruppo);
                                            echo"</div>
                                        </div>";
                                        if($mostraAggiungiAlCarrello==true) {
                                            StampaContenuti::stampaPulsanteCarrello($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$linkProdotto,$datiGruppo);
                                        }
                                    echo"</div>
                                    </div>
                            </div>
                        </div>";
            }
        }
        
        static function stampaPrezzoProdotto($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$datiGruppo) {
            $prezzoBase    = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzo"] + ($prodotto["prezzo"] * $prodotto["iva"] / 100) : $prodotto["prezzo"];
            $prezzoOfferta = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzoOfferta"] + ($prodotto["prezzoOfferta"] * $prodotto["iva"] / 100) : $prodotto["prezzoOfferta"];
            $asterisco	    = "";

            // imposto il suffisso IVA
            if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA esclusa") {
            	$suffissoIva = $gestoreTraduzioni->traduci("+ IVA",$prodotto["lingua"]);
            }
            else if($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") {
            	$suffissoIva = $gestoreTraduzioni->traduci("IVA inclusa",$prodotto["lingua"]);
            }
            else {
            	$suffissoIva = "";
            }
            
            if($datiGruppo != null) {
		$prezzoBase    = round($prezzoBase - ($prezzoBase * $datiGruppo["percentualeSconto"] / 100),2);
		$prezzoOfferta = ($prezzoOfferta!=0) ? round($prezzoOfferta - ($prezzoOfferta * $datiGruppo["percentualeSconto"] / 100),2) : 0;
		$asterisco = "*";
            }
            if($prezzoOfferta>0) {
                echo"<h5 class=\"mb-0\"><strong> € {$prezzoOfferta}</strong><small> $suffissoIva $asterisco</small></h5>";
                echo"<h6 class=\"text-muted\"> <del>€ {$prezzoBase}<small> $suffissoIva $asterisco</small></del></h6>";
            }
            else {
                echo"<h5 class=\"\"><strong> € {$prezzoBase}</strong><small> $suffissoIva $asterisco</small></h5>";
            }
            if($datiGruppo!=null) {
                echo"<small>* Prezzo riservato ai {$datiGruppo["nomeGruppo"]} </small>";
            }
        }
        
        static function stampaPulsanteCarrello($gestoreTraduzioni,$prodotto,$impostazioniEcommerce,$linkProdotto,$datiGruppo) {
            $stringaAggiungiAlCarrello = $gestoreTraduzioni->traduci("Aggiungi al carrello",$prodotto["lingua"]);
            $prezzoBase    = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzo"] + ($prodotto["prezzo"] * $prodotto["iva"] / 100) : $prodotto["prezzo"];
            $prezzoOfferta = ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $impostazioniEcommerce["mostraIvaPrezziNegozio"]=="IVA inclusa") ? $prodotto["prezzoOfferta"] + ($prodotto["prezzoOfferta"] * $prodotto["iva"] / 100) : $prodotto["prezzoOfferta"];
            $disponibilita = ($prodotto["prodottoInesauribile"]=="si") ? 1000 : $prodotto["disponibilita"];
            
            if($datiGruppo != null) {
                $prezzoBase    = round($prezzoBase - ($prezzoBase * $datiGruppo["percentualeSconto"] / 100),2);
                $prezzoOfferta = ($prezzoOfferta!=0) ? round($prezzoOfferta - ($prezzoOfferta * $datiGruppo["percentualeSconto"] / 100),2) : 0;
            }
            echo"<div class=\"buttons\">";
            if($prodotto["usaVariazioni"]=="si") {
                echo"<a href=\"$linkProdotto\" class=\"btn btn-outline-primary btn-block sharp leggi-tutto btn-sm\">{$gestoreTraduzioni->traduci("Dettagli",$prodotto["lingua"])}</a>";
            }
            else if($prezzoOfferta>0) {
                echo"<button class=\"btn btn-outline-primary btn-block sharp aggiungi btn-sm\" onclick=\"aggiungiAlCarrello('prodottoEcommerce',{$prodotto["id"]},'{$prodotto["nome"]}','{$prodotto["immagine"]}',$prezzoOfferta,$disponibilita)\" >$stringaAggiungiAlCarrello</button>";
            }
            else {
                echo"<button class=\"btn btn-outline-primary btn-block sharp aggiungi btn-sm\" onclick=\"aggiungiAlCarrello('prodottoEcommerce',{$prodotto["id"]},'{$prodotto["nome"]}','{$prodotto["immagine"]}',$prezzoBase,$disponibilita)\" >$stringaAggiungiAlCarrello</button>";
            }
            echo"</div>";
        }
 
        static function percorsoImmagine($prodotto) {
            if($prodotto["immagine"]!="") {
                return"{$prodotto["immagine"]}";
            }
            else {
                return"immagini/altro/segnaposto.png";
            }
        }
                
        /*
         * questo metodo stampa un messaggio di errore
         * è possibile scegliere la classe del div, se non si imposta diversamente viene mostrata alert alert-danger
         */
        function messaggioDiErrore($messaggio,$classeDivMessaggio = "border-danger text-danger") {
            echo"<div class=\"container my-3 \">"
            . "<div class=\"card $classeDivMessaggio\">"
                ."<div class=\"card-body\">$messaggio</div>
                </div>"
            . "</div>";
        }
    }
